<?php

namespace App\Http\Resources\Auth;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class VerifyEmailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'status' => 'verification-link-sent',
            'message' => 'Verification email sent.'
        ];
    }

    public function withResponse($request, $response)
    {
        $response->setStatusCode(202);
    }
}
