<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\URL;
use Carbon\Carbon;

class CustomPasswordReset extends Notification
{
    use Queueable;

    /**
     * The password reset token.
     */
    protected $token;

    /**
     * Create a notification instance.
     */
    public function __construct(string $token)
    {
        $this->token = $token; // Store the token in the property
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $verificationUrl = $this->verificationUrl($notifiable);

        return (new MailMessage)
            ->subject('Password Reset')
            ->markdown('emails.password-reset', [
                'url' => $verificationUrl,
                'user' => $notifiable,
            ]);
    }

    /**
     * Generate a signed verification URL.
     */
    protected function verificationUrl($notifiable)
    {
        $url = config('app.frontend_url') . 
                "/reset-password/{$this->token}?email={$notifiable->getEmailForPasswordReset()}";

        $finalUrl = config('app.frontend_url').'?verification_url='. urlencode($url);

        return $finalUrl;
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
