<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RoleController;


Route::middleware(['auth:sanctum', 'verified'])->prefix('role')->group(function () {
  Route::get('/', [RoleController::class, 'index'])->name('role.index');
  Route::get('/{id}', [RoleController::class, 'show'])->name('role.show');
  Route::post('/', [RoleController::class, 'store'])->name('role.store');
  Route::put('/{id}', [RoleController::class, 'update'])->name('role.update');
  Route::delete('/{id}', [RoleController::class, 'destroy'])->name('role.destroy');
});