<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;


Route::middleware(['auth:sanctum', 'verified'])->prefix('user')->group(function () {
  Route::get('/', [UserController::class, 'index'])->name('user.index');
  Route::get('/{id}', [UserController::class, 'show'])->name('user.show');
  Route::post('/', [UserController::class, 'store'])->name('user.store');
  Route::put('/{user}', [UserController::class, 'update'])->name('user.update');
  Route::delete('/{id}', [UserController::class, 'destroy'])->name('user.destroy');
});